#ifndef ALD_THREADED_PLUGIN_H
#define ALD_THREADED_PLUGIN_H

#include <stdbool.h>


typedef void (*ald_plugin_connection_callback_t)(void * dataPtr, void *dataPtr2);
typedef void (*ald_plugin_disconnection_callback_t)(void * dataPtr, void *dataPtr2);

/* calback function to calcluate the log level of a contexts based on different plugin configurations.
 This function is called when after the initialisation of the plugin and when the plugin configuration 
  changes */
typedef void (*ald_plugin_calculate_log_level_callback_t)(unsigned int new_level,void * ptr, void *ptr2);

/* Callback function to be called when a command is received from the ald-Client or external source
 * Command either accepted or rejected based on the system configurations and security configurations
 */
typedef void (*ald_plugin_cmd_received_callback_t)(char* apid, char* ctxid,unsigned int service);

typedef struct ald_plugin_callbacks_t
{
    ald_plugin_connection_callback_t connection_clbk;
    ald_plugin_disconnection_callback_t disConnection_clbk;
    ald_plugin_calculate_log_level_callback_t calculate_log_level_clbk;
    ald_plugin_cmd_received_callback_t cmd_received_clbk;
} ald_plugin_callbacks_t;



//------------------------------------ init / deinit -----------------------------------------------------------------
int ald_plugin_init(const ald_plugin_callbacks_t *callbacks, unsigned int default_level);

int ald_plugin_deinit(void * data_ptr, void * data_ptr2);


//------------------------------------ event handling ----------------------------------------------------------------
int ald_plugin_get_pollfd(void);

int ald_plugin_dispatch(void * data_ptr, void * data_ptr2);

int ald_plugin_getLoglevel(char* apid, char* ctid);
//--------------------------------------------------------------------------------------------------------------------

//------------------------------------ properties --------------------------------------------------------------------
unsigned int ald_plugin_get_security_level(bool onConnection);

//--------------------------------------------------------------------------------------------------------------------


#endif
